###################################################
### code chunk number : set your work directory
###################################################
## 
## Firstly, set your work directory to contain "main_goodness_of_fit.R".
## Secondly, make sure there is a folder named "figure"
## in the same directory of "main_goodness_of_fit.R".
##


####################################################
### code chunk number : compute alpha_1_beta_1 and X and save as gof_data.mat
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
alpha = 3; alpha            ## hyperparameter
beta = 1; beta              ## hyperparameter
n = 1500; n                 ## sample size
M = 100; M                  ## number of required simulations

## 
## compute alpha_1_beta_1 and X and save as gof_data.mat
## 

alpha_1_beta_1 = matrix(0, nrow = M, ncol = 2)
X = matrix(0, nrow = M, ncol = n)
keep_seed = NULL
m = 1
k = 1
repeat{
	cat("\n"); print(paste("In this cycle, k = ", k, sep = "")); cat("\n")
	
	## simulate the sample
	set.seed(k)
	theta_k = 1 / rgamma(n, shape = alpha, scale = beta)
	x_k = runif(n, 0, theta_k)
	
	## Moment estimators
	alpha_1_beta_1_k = Moment_estimators(x_k)
	cat("\n alpha_1_beta_1_k\n"); print(alpha_1_beta_1_k); cat("\n")
	
	if (all(alpha_1_beta_1_k > 0)){
		alpha_1_beta_1[m, ] = alpha_1_beta_1_k
		X[m, ] = x_k
		m = m + 1
		keep_seed = c(keep_seed, k)
		if (m == (M + 1)) break
	}
	k = k + 1
}
k
keep_seed
length(keep_seed)
alpha_1_beta_1

## Install the package R.matlab first.
## install.packages(pkgs = "R.matlab", repos = "http://cloud.r-project.org/", dependencies=TRUE)
library(R.matlab)
writeMat("data/gof_data.mat", alpha.1.beta.1 = alpha_1_beta_1, X = X)
data = readMat("data/gof_data.mat")
str(data)
data$alpha.1.beta.1
dim(data$alpha.1.beta.1)
dim(data$X)


####################################################
### code chunk number : run goodness_of_fit section in Xshell
####################################################

## 
## goodness_of_fit
## 
# cd /BIGDATA1/cqu_yyzhang_1/MATLAB/work/U_IG
# yhbatch -N 1 -p rhenv main_s_goodness_of_fit_MLE_5_20.sh
# yhq -a

# After the computations in the supercomputer, we can obtain alpha_2_beta_2 (100*2).


####################################################
### code chunk number : read alpha_2_beta_2 from Matlab file and perform KS test
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
alpha = 3; alpha            ## hyperparameter
beta = 1; beta              ## hyperparameter
n = 1500; n                 ## sample size
M = 100; M                  ## number of required simulations

## 
## read alpha_1_beta_1 and X
## 
library(R.matlab)
data = readMat("data/gof_data.mat")
str(data)
alpha_1_beta_1 = data$alpha.1.beta.1; alpha_1_beta_1
X = data$X

## 
## read alpha_2_beta_2 from Matlab file
##
source("subfunctions.R")
alpha_2_beta_2 = NULL
res = vector("list", 20)
Time_alpha_2_beta_2_seconds = numeric(20); names(Time_alpha_2_beta_2_seconds) = 1:20
for (k in 1:20){
	s_k = string_k(k)
	res[[k]] = readMat(paste("data/goodness-of-fit/savefile_", s_k, ".mat", sep = ""))
	alpha_2_beta_2 = rbind(alpha_2_beta_2, res[[k]][[1]])
	Time_alpha_2_beta_2_seconds[k] = res[[k]][[2]]
}
dim(alpha_2_beta_2)
alpha_2_beta_2
Time_alpha_2_beta_2_seconds
Time_alpha_2_beta_2_hours = Time_alpha_2_beta_2_seconds / 3600; Time_alpha_2_beta_2_hours


## 
## KS test
## 
M1 = 98; M1 ## number of available simulations
alpha_1_beta_1_M1 = alpha_1_beta_1[-(79:80), ]; alpha_1_beta_1_M1
alpha_2_beta_2_M1 = alpha_2_beta_2[-(79:80), ]; alpha_2_beta_2_M1
X_M1 = X[-(79:80), ]
dim(X_M1)

alpha_1 = alpha_1_beta_1_M1[, 1]
beta_1 = alpha_1_beta_1_M1[, 2]
alpha_2 = alpha_2_beta_2_M1[, 1]
beta_2 = alpha_2_beta_2_M1[, 2]
D_0 = D_1 = D_2 = p_value_0 = p_value_1 = p_value_2 = numeric(M1)
for (m in 1:M1){
	cat("\n"); print(paste("In this cycle, m = ", m, sep = "")); cat("\n")
	x_m = X_M1[m, ]
	
	## U_IG(3, 1)
	ks_test_0_m = ks.test(x_m, "p_U_IG_alpha_Beta", 3, 1)
	cat("\n ks_test_0_m\n"); print(ks_test_0_m); cat("\n")
	D_0[m] = ks_test_0_m$statistic
	p_value_0[m] = ks_test_0_m$p.value
	
	## U_IG(alpha_1, beta_1)
	ks_test_1_m = ks.test(x_m, "p_U_IG_alpha_Beta", alpha_1[m], beta_1[m])
	cat("\n ks_test_1_m\n"); print(ks_test_1_m); cat("\n")
	D_1[m] = ks_test_1_m$statistic
	p_value_1[m] = ks_test_1_m$p.value

	## U_IG(alpha_2, beta_2)
	ks_test_2_m = ks.test(x_m, "p_U_IG_alpha_Beta", alpha_2[m], beta_2[m])
	cat("\n ks_test_2_m\n"); print(ks_test_2_m); cat("\n")
	D_2[m] = ks_test_2_m$statistic
	p_value_2[m] = ks_test_2_m$p.value
}
D_M1 = cbind(D_0, D_1, D_2);  round(D_M1, 4)
p_value_M1 = cbind(p_value_0, p_value_1, p_value_2); round(p_value_M1, 4)


## 
## compute averages and proportions
## 

## compute averages
Average_D_M1 = colMeans(D_M1); round(Average_D_M1, 4)
Average_p_value_M1 = colMeans(p_value_M1); round(Average_p_value_M1, 4)

## compute proportions
source("subfunctions.R")
Proportions_D_M1 = Compute_Proportions_vector_pmin(D_M1[, 1], D_M1[, 2], D_M1[, 3])
round(Proportions_D_M1, 3)

Proportions_p_value_M1 = Compute_Proportions_vector_pmax(p_value_M1[, 1], p_value_M1[, 2], p_value_M1[, 3])
round(Proportions_p_value_M1, 3)

Proportions_accept_H0 = colMeans(p_value_M1 > 0.05)
round(Proportions_accept_H0, 3)

## summarize the results
A = matrix(0, nrow = 5, ncol = 3)
colnames(A) = c("oracle", "moment", "mle")
rownames(A) = c("Average_D_M1", "Average_p_value_M1", "Proportions_D_M1", "Proportions_p_value_M1", "Proportions_accept_H0")
A[1, ] = round(Average_D_M1, 4)
A[2, ] = round(Average_p_value_M1, 4)
A[3, ] = round(Proportions_D_M1, 3)
A[4, ] = round(Proportions_p_value_M1, 3)
A[5, ] = round(Proportions_accept_H0, 3)
A

Generate_Matrix_Latex(A)


## 
## boxplots
## 
names = c("oracle", "moment", "mle")
col = c("red", "purple", "blue")

dev.new()
boxplot(D_M1[, 1], D_M1[, 2], D_M1[, 3], names = names, col = col, sub = "(a)")
title("D values")
savePlot(filename = paste("figure/U-IG_D_values", sep=""), type = c("pdf"))

dev.new()
boxplot(p_value_M1[, 1], p_value_M1[, 2], p_value_M1[, 3], names = names, col = col, sub = "(b)")
title("p-values")
savePlot(filename = paste("figure/U-IG_p_values", sep=""), type = c("pdf"))


